set sql_safe_updates=0;

-- Appointment

SET @sgAppointmentDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPOINTMENT_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T1.appointeeName AS PRINT_NAME,
    T1.appointeeEmailId AS EMAIL_ID,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    TRIM(SUBSTRING_INDEX(personToMeet, '/', - 1)) AS PERSON_TO_MEET,
    TRIM(SUBSTRING_INDEX(appointeeContactNo, '-', 1)) AS MOBILE_CODE,
    TRIM(SUBSTRING_INDEX(appointeeContactNo, '-', - 1)) AS MOBILE_NO,
    TRIM(SUBSTRING_INDEX(appointeeName, '/', - 1)) AS FIRST_NAME,
    (Case 
    when T2.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T2.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T2.logoUrl)end) as LOGO_URL
FROM
    sg_appointment T1
        LEFT JOIN
    academy_location T2 ON T2.id = T1.academyLocationId
   		LEFT JOIN
    organizations org on org.id = 1
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId` = @sgAppointmentDT;

    
    
SET @sgAppointmentTemConf=(SELECT id FROM msg_template_config WHERE `code`='Appointment');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title> </title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">An appointment has been booked on <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> at <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> with $recipientData[&quot;PERSON_TO_MEET&quot;].</span></span></p>
		
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @sgAppointmentTemConf and msgDeliveryModeId in (1,4);



-- Approve Admission

/*SET @ApproveAdmDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_ADMISSION_APPLICANT_INFO');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T2.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    (Case 
    when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL
FROM
    `application` T1
        INNER JOIN
    `applicant_person` T2 ON T2.id = T1.applicantPersonId
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
    T2.id IN (namedParams)" WHERE `dataProviderId` = @ApproveAdmDT;

    
    
SET @ApproveAdmTemConf=(SELECT id FROM msg_template_config WHERE `code`='Approve Admission');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>,<br />
			Your admission has been approved with the following details :&nbsp;<br />
			Program : <strong>$templateData[&quot;PROGRAM_NAME&quot;]</strong><br />
			Batch : <strong>$templateData[&quot;BATCH_NAME&quot;]</strong><br />
			Seat type : <strong>$templateData[&quot;SEAT_NAME&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td></tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @ApproveAdmTemConf and msgDeliveryModeId in (1);*/



-- Approve Admission Advisor

SET @ApproveAdmAdvDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_ADMISSION_ADVISOR_INFO');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T13.salutationName AS SALUTATION_NAME,
    T8.firstName AS FIRST_NAME,
    T8.middleName AS MIDDLE_NAME,
    T8.lastName AS LAST_NAME,
    T8.emailId AS EMAIL_ID,
    T8.mobileNumber AS MOBILE_NO,
    T8.mobileCountryCode AS MOBILE_CODE,
    T5.firstName AS STUDENT_FIRST_NAME,
    T5.middleName AS STUDENT_MIDDLE_NAME,
    T5.lastName AS STUDENT_LAST_NAME,
    T10.batchName AS BATCH_NAME,
    T10.printName AS BATCH_PRINT_NAME,
    T11.programNameToBePrint AS PROGRAM_NAME,
    T12.seatName AS SEAT_NAME,
    T14.academyName AS ACADEMY_NAME,
    T14.locationName AS LOCATION_NAME,
    T14.displayName AS ACADEMY_NAME_LOCATION,
    T14.id AS ACADEMY_LOCATION_ID,
    DATE_FORMAT(DATE(NOW()), '%d-%m-%Y') AS TODAY_DATE,
    (Case 
    when T14.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T14.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T14.logoUrl)end) as LOGO_URL
FROM
    application_admission_detail T1
        INNER JOIN
    application_program T2 ON T1.applicationProgramId = T2.id
        LEFT JOIN
    admission T3 ON T3.applicationAdmissionId = T1.id
        LEFT JOIN
    students T4 ON T4.userId = T3.studentId
        LEFT JOIN
    persons T5 ON T5.id = T4.personId
        LEFT JOIN
    users T6 ON T6.id = T1.advisiorId
        LEFT JOIN
    staffs T7 ON T7.userId = T6.id
        LEFT JOIN
    persons T8 ON T8.id = T7.personId
        LEFT JOIN
    salutations T13 ON T13.id = T8.salutationId
        LEFT JOIN
    prog_batch_seat_config T9 ON T9.id = T1.programBatchSeatConfigId
        LEFT JOIN
    batches T10 ON T10.id = T9.programBatchId
        LEFT JOIN
    programs T11 ON T11.id = T10.programId
        LEFT JOIN
    seat_types T12 ON T12.id = T9.seatTypeId
        LEFT JOIN
    academy_location T14 ON T14.id = T3.academyLocationId
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
    T1.id = namedParams" WHERE `dataProviderId` = @ApproveAdmAdvDT;

    
    
SET @ApproveAdmAdvDTTemConf=(SELECT id FROM msg_template_config WHERE `code`='Approve Advisor Admission Template');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;SALUTATION_NAME&quot;]&nbsp;$recipientData[&quot;FIRST_NAME&quot;]&nbsp;$recipientData[&quot;LAST_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">You have successfully approved the admission of&nbsp; <strong>$recipientData[&quot;STUDENT_FIRST_NAME&quot;]&nbsp;$recipientData[&quot;STUDENT_LAST_NAME&quot;]</strong>&nbsp;on&nbsp;<strong>$recipientData[&quot;TODAY_DATE&quot;]</strong> with the following details:</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Academy Location:&nbsp;<strong>$recipientData[&quot;ACADEMY_NAME_LOCATION&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Program:&nbsp;<strong>$recipientData[&quot;PROGRAM_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Batch:&nbsp;<strong>$recipientData[&quot;BATCH_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Seat Type:&nbsp;<strong>$recipientData[&quot;SEAT_NAME&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @ApproveAdmAdvDTTemConf and msgDeliveryModeId in (1,4);



-- Approve Application

/*SET @ApproveAppDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='APPROVE_APPLICATION_RECIPIENTS');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T1.`code` AS APPLICATION_CODE,
    (Case 
    when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
    when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
    else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL
FROM
    application T1
        LEFT JOIN
    applicant_person T2 ON T1.applicantPersonId = T2.id
        LEFT JOIN
    salutations T3 ON T3.id = T2.salutationId
        LEFT JOIN
    academy_location T4 ON T4.id = T1.issuedFromAcademyLocation
        LEFT JOIN
    organizations org ON org.id = 1
WHERE
    T1.id IN (namedParams)" WHERE `dataProviderId` = @ApproveAppDT;

    
    
SET @ApproveAppTemConf=(SELECT id FROM msg_template_config WHERE `code`='Approve Application Template');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello <strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong>,</p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your application with no. <strong>$recipientData[&quot;APPLICATION_CODE&quot;]</strong> has been approved.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>issuedFromAcademyLocation`
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @ApproveAppTemConf and msgDeliveryModeId in (1);*/

-- Assign meeting minute


SET @meetingDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_MEETING_MEMBER_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `users` T1
        INNER JOIN
    `staffs` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `event_meeting_minutes_task` T5 ON T1.id = T5.ownerId
        LEFT JOIN
    `user_academy_locations` ual ON ual.userId = T1.id
        LEFT JOIN
    `academy_location` al ON al.id = ual.academyLocationId
        LEFT JOIN
    `organizations` org ON org.id = 1
WHERE
    T5.id IN (namedParams)
        AND ual.whetherPrimary = TRUE 
UNION SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `users` T1
        INNER JOIN
    `students` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `event_meeting_minutes_task` T5 ON T1.id = T5.ownerId
        LEFT JOIN
    `admission` adm ON adm.studentId = T1.`id`
        LEFT JOIN
    `academy_location` al ON al.id = adm.academyLocationId
		LEFT JOIN
    `program_batch_students` pbs ON pbs.admissionId = adm.id
		LEFT JOIN
    `organizations` org ON org.id = 1
WHERE
    T5.id IN (namedParams) AND adm.activeStatus = TRUE and pbs.isCurrentPeriod = true
    and pbs.exitDate is null
UNION SELECT 
    T5.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `users` T1
        INNER JOIN
    `parents` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `event_meeting_minutes_task` T5 ON T1.id = T5.ownerId
        LEFT JOIN
    `user_academy_locations` ual ON ual.userId = T1.id
        LEFT JOIN
    `academy_location` al ON al.id = ual.academyLocationId
        LEFT JOIN
    `organizations` org ON org.id = 1
WHERE
    T5.id IN (namedParams)
        AND ual.whetherPrimary = TRUE" WHERE `dataProviderId` = @meetingDT;

    
    
SET @meetingDTTemConf=(SELECT id FROM msg_template_config WHERE `code`='Committee Management Notification');


UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">A meeting Minute=$templateData[&quot;TYPE&quot;]&nbsp;has been assigned to you on Date=$templateData[&quot;ASSIGN_DATE&quot;]. You can mark it Complete from Meeting Minute Dashlet.</p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @meetingDTTemConf and msgDeliveryModeId in (1,4);

-- Reset Password


SET @rpDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='RESET_PASSWORD_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    'N/A' AS inactiveReasonCode,
    'N/A' AS urlcode,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `users` T1
        INNER JOIN
    `staffs` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `user_academy_locations` ual ON ual.userId = T1.id
        LEFT JOIN
    `academy_location` al ON al.id = ual.academyLocationId
        LEFT JOIN
    `organizations` org ON org.id = 1
    LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
WHERE
    T1.id IN (namedParams) AND ual.whetherPrimary = TRUE group by T1.id
UNION SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID,
    adm.inactiveReasonCode AS inactiveReasonCode,
    adm.code AS urlcode,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `users` T1
        INNER JOIN
    `students` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        inner JOIN
    `admission` adm ON adm.studentId = T1.`id`
        inner JOIN
    `academy_location` al ON al.id = adm.academyLocationId
		inner JOIN
    `program_batch_students` pbs ON pbs.admissionId = adm.id
		LEFT JOIN
    `organizations` org ON org.id = 1
    LEFT JOIN
    `fire_base_persons_info` f ON f.userId = T1.id
WHERE
    T1.id IN (namedParams) AND adm.activeStatus = TRUE and pbs.isCurrentPeriod = true
    and pbs.exitDate is null group by T1.id" WHERE `dataProviderId` = @rpDT;

    
    
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='RESET_PASSWORD');
SET @rpTemConf=(SELECT id FROM msg_template_config WHERE `code`='Reset password Template' and sysMsgEventId=@sysMsgEventId );

UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]</strong>&nbsp;<strong>$recipientData[&quot;LAST_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your Password has been reset with following credential&nbsp;<br />
			<br />
			Login ID:&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong><br />
			Password: <strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @rpTemConf and msgDeliveryModeId in (1,4);




-- Parent Reset Password

SET @prpDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='PARENT_RESET_PASSWORD_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    T2.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `users` T1
        LEFT JOIN
    `parents` T4 ON T4.`userId` = T1.`id`
        LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
        LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
        LEFT JOIN
    `user_academy_locations` ual ON ual.userId = T1.id
        LEFT JOIN
    `academy_location` al ON al.id = ual.academyLocationId
        LEFT JOIN
    `organizations` org ON org.id = 1
WHERE
    T4.userId IN (namedParams) AND ual.whetherPrimary = TRUE" WHERE `dataProviderId` = @prpDT;

    
    
SET @prpTemConf=(SELECT id FROM msg_template_config WHERE `code`='Parent Reset Password');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;]</strong>&nbsp;<strong>$recipientData[&quot;LAST_NAME&quot;]</strong></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px">Your Password has been reset with following credential&nbsp;<br />
			<br />
			Login ID:&nbsp;<strong>$templateData[&quot;LOGIN_ID&quot;]</strong><br />
			Password: <strong>$templateData[&quot;PASSWORD&quot;]</strong></p>
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @prpTemConf and msgDeliveryModeId in (1,4);


-- BirthDay


SET @bdDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='MSG_BIRTHDAY_GREETING_RCPNT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "select ID,BIRTH_DATE,SALUTATION_NAME,FIRST_NAME,MIDDLE_NAME,LAST_NAME,EMAIL_ID,MOBILE_NO,MOBILE_CODE,group_concat(DEVICE_ID) AS DEVICE_ID,LOGO_URL from
(
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as LAST_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
        (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
		WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
		ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL,
        f.deviceTokenId AS DEVICE_ID
	from 
		students s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
        LEFT JOIN fire_base_persons_info f ON f.userId = s.userId
		LEFT JOIN admission adm ON adm.studentId = s.userId AND adm.activeStatus = TRUE
		LEFT JOIN academy_location al ON al.id = adm.academyLocationId
		INNER JOIN program_batch_students pbs ON pbs.admissionId = adm.id  and pbs.isCurrentPeriod = true and pbs.exitDate is null
		LEFT JOIN organizations org ON org.id = 1
	UNION
	select 
		s.userId as ID,
        p.birthDate as BIRTH_DATE,
        sal.salutationName as SALUTATION_NAME,
        p.firstName as FIRST_NAME,
        p.middleName as MIDDLE_NAME,
        p.lastName as MIDDLE_NAME,
        p.emailId as EMAIL_ID,
        p.mobileNumber as MOBILE_NO,
        p.mobileCountryCode as MOBILE_CODE,
		(CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
		WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
		ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL,
        f.deviceTokenId AS DEVICE_ID
	from 
		staffs s
		inner join users u on u.id = s.userId
		inner join persons p on p.id = s.personId
		left join salutations sal on sal.id = p.salutationId
		LEFT JOIN fire_base_persons_info f ON f.userId = u.id
        LEFT JOIN user_academy_locations ual ON ual.userId = u.id AND ual.whetherPrimary = TRUE 
	LEFT JOIN academy_location al ON al.id = ual.academyLocationId
	LEFT JOIN organizations org ON org.id = 1
) as PSEUDO
 where date_format(BIRTH_DATE,'%m-%d') = date_format(now(),'%m-%d')
and id in (namedParams) group by id" WHERE `dataProviderId` = @bdDT;

    
    
SET @bdTemConf=(SELECT id FROM msg_template_config WHERE `code`='MSG_BIRTHDAY_GREETING_TEMPLATE');
UPDATE `msg_template` SET `msgContent`='<table border="0" cellpadding="1" cellspacing="1" style="width:500px; border-collapse:collapse">
       <tr>
       	<td align="center" style="background-color: #727272; color: #f4f4f4; margin:0px; padding:4px;">
       		<h3 style="margin-top:20px;">Wish You a Very Happy Birthday </h3>
       	</td>
       </tr>  
      <tr>
      	<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
      	</td>
      </tr>
      </table>' WHERE `msgTemplateConfigId`= @bdTemConf and msgDeliveryModeId in (1,4);


      
-- Person To Meet Appointment


SET @ptmaDT=(SELECT id FROM dtprovider WHERE `dataProviderName`='PERSON_TO_MEET_APPOINTMENT_RECIPIENT');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T3.emailId AS EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.mobileNumber AS MOBILE_NO,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    ent.printName AS CREATED_PRINT_NAME,
    ent.firstName AS CREATED_FIRST_NAME,
    ent.lastName AS CREATED_LAST_NAME,
    TRIM(SUBSTRING_INDEX(appointeeName, '/', - 1)) AS APPOINTEE_NAME,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    staffs entryBy ON entryBy.userId = T1.entryBy
        LEFT JOIN
    persons ent ON ent.id = entryBy.personId
        LEFT JOIN
    `user_academy_locations` ual ON ual.userId = T2.userId
        LEFT JOIN
    `academy_location` al ON al.id = ual.academyLocationId
        LEFT JOIN
    `organizations` org ON org.id = 1
WHERE
    T1.id IN (namedParams)
        AND ual.whetherPrimary = TRUE 
UNION SELECT 
    T1.id AS ID,
    T3.emailId AS EMAIL_ID,
    T3.mobileCountryCode AS MOBILE_CODE,
    T3.mobileNumber AS MOBILE_NO,
    T3.firstName AS FIRST_NAME,
    T3.lastName AS LAST_NAME,
    T3.printName AS PRINT_NAME,
    DATE_FORMAT(T1.visitTime, '%h:%i %p') AS VISIT_TIME,
    DATE_FORMAT(T1.expectedOutTime, '%h:%i %p') AS OUT_TIME,
    DATE_FORMAT(T1.appointmentDate, '%d-%m-%Y') AS APPOINTMENT_DATE,
    ent.printName AS CREATED_PRINT_NAME,
    ent.firstName AS CREATED_FIRST_NAME,
    ent.lastName AS CREATED_LAST_NAME,
    TRIM(SUBSTRING_INDEX(appointeeName, '/', - 1)) AS APPOINTEE_NAME,
    (CASE WHEN al.logoUrl IS NULL AND org.orgUrl IS NOT NULL THEN CONCAT(org.orgUrl,'/','emailer/images/logo_default_image.png')
        WHEN al.logoUrl IS NULL AND org.orgUrl IS NULL THEN 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        ELSE CONCAT(org.orgUrl, '/', al.logoUrl) END) AS LOGO_URL
FROM
    `sg_appointment` T1
        LEFT JOIN
    staffs T2 ON T2.userId = T1.personToMeetId
        LEFT JOIN
    persons T3 ON T3.id = T2.personId
        INNER JOIN
    students entryBy ON entryBy.userId = T1.entryBy
        LEFT JOIN
    persons ent ON ent.id = entryBy.personId
        LEFT JOIN
    `admission` adm ON adm.studentId = T2.userId
        LEFT JOIN
    `academy_location` al ON al.id = adm.academyLocationId
        LEFT JOIN
    `program_batch_students` pbs ON pbs.admissionId = adm.id
        LEFT JOIN
    `organizations` org ON org.id = 1
WHERE
    T1.id IN (namedParams)
        AND adm.activeStatus = TRUE
        AND pbs.isCurrentPeriod = TRUE
        AND pbs.exitDate IS NULL" WHERE `dataProviderId` = @ptmaDT;

    
    
SET @ptmaTemConf=(SELECT id FROM msg_template_config WHERE `code`='Person To Meet Appointment');
UPDATE `msg_template` SET `msgContent`='<html>
<head>
	<title></title>
</head>
<body>&nbsp;
<title></title>
<p>&nbsp;</p>
<title></title>
<table align="center" style="min-width:700px; max-width:800px; border-collapse:collapse">
	<tbody>
		<tr style="background-color:#f0f0f0; line-height:20px;">
			<td style="padding:20px 20px 20px 20px;">
			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">Hello&nbsp;<strong>$recipientData[&quot;FIRST_NAME&quot;] $recipientData[&quot;LAST_NAME&quot;]</strong></span></span></p>

			<p style="font-family:sans-serif, Arial, Helvetica; font-size:12px"><span style="font-size:12px;"><span style="font-family:arial,helvetica,sans-serif;">An appointment has been booked on <strong>$recipientData[&quot;APPOINTMENT_DATE&quot;]</strong> From <strong>$recipientData[&quot;VISIT_TIME&quot;]</strong> To<strong> $recipientData[&quot;OUT_TIME&quot;]</strong></strong> with $recipientData[&quot;APPOINTEE_NAME&quot;].</span></span></p>
		
			</td>
		</tr>
		<tr>
			<td align="center" style="background-color: #727272; margin:0px; padding:4px;"><img src="$recipientData[&quot;LOGO_URL&quot;]" height="80"></td>
		</tr>
	</tbody>
</table>
</body>
</html>' WHERE `msgTemplateConfigId`= @ptmaTemConf and msgDeliveryModeId in (1,4);

set sql_safe_updates=1;

